package com.burhanstore.neonbubblequest.Utils.network

import com.google.gson.JsonObject
import android.util.Base64
import javax.crypto.Cipher
import javax.crypto.KeyGenerator
import javax.crypto.SecretKey
import javax.crypto.spec.IvParameterSpec
import javax.crypto.spec.SecretKeySpec

object CryptoUtil {
    // Generate AES key (128-bit)
    fun generateAESKey(): SecretKey {
        val keyGen = KeyGenerator.getInstance("AES")
        keyGen.init(128)
        return keyGen.generateKey()
    }

    // Encrypt JSON string
    fun encrypt(json: JsonObject, secretKey: SecretKey): String {
        val cipher = Cipher.getInstance("AES/CBC/PKCS5Padding")
        val iv = ByteArray(16) { 0 } // fixed IV, or you can randomize and send with payload
        cipher.init(Cipher.ENCRYPT_MODE, secretKey, IvParameterSpec(iv))
        val encrypted = cipher.doFinal(json.toString().toByteArray(Charsets.UTF_8))
        return Base64.encodeToString(encrypted, Base64.NO_WRAP)
    }

    // Convert SecretKey to Base64 string for sending (optional)
    fun keyToString(secretKey: SecretKey): String {
        return Base64.encodeToString(secretKey.encoded, Base64.NO_WRAP)
    }

    // Convert Base64 string back to SecretKey
    fun stringToKey(keyStr: String): SecretKey {
        val bytes = Base64.decode(keyStr, Base64.NO_WRAP)
        return SecretKeySpec(bytes, "AES")
    }
}
